//
//  NSMenu+onepassword.h
//  ApplicationFrameworks
//
//  Created by Chad Seldomridge on 8/31/15.
//
//

#import <Cocoa/Cocoa.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>
#import <OnePasswordCommon/OnePasswordCommon.h>

@interface NSMenu (onepassword)

+ (NSArray *)op_profileMenuItemsWithProfileGroups:(NSArray<id<OPProfileGroup>> *)profileGroups
									 userAccounts:(NSArray<B5UserAccount *> *)userAccounts
										   target:(id)target
										 selector:(SEL)selector
										imageType:(OPProfileImage)imageType
										imageSize:(NSSize)imageSize
									activeProfile:(id<OPGenericProfile>)activeProfile 
						   primaryProfileIsLocked:(BOOL)primaryProfileIsLocked 
							dataMonitorOperations:(NSArray<id<OPImageDataOperationMonitor>> **)dataMonitorOperations
								   showFrozenLink:(BOOL)showFrozenLink
							   frozenClickHandler:(void (^)(B5UserAccount *account))frozenClickHandler;

+ (BOOL)validatePermissionsForMenuItem:(NSMenuItem *)menuItem
					   againstProfiles:(NSArray<id<OPGenericProfile>> *)profiles
					 withPermissionMap:(NSDictionary<NSNumber *, NSArray<NSString *> *> *)permissionMap;

@end
